<?php
/*--------------------------------------------------------------
   Overview.php 2021-09-07
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2021 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Admin\Modules\Statistics\App\Overview\Action;

use Gambio\Admin\Application\Http\VuePageAction;
use Gambio\Core\Application\Http\Request;
use Gambio\Core\Application\Http\Response;

/**
 * @codeCoverageIgnore
 */
class Overview extends VuePageAction
{
    private const JAVASCRIPT_ENTRYPOINT = 'statistics';
    
    private const TRANSLATION_SECTION = 'statistics';
    
    private const TRANSLATIONS = [
        ['language_code', self::TRANSLATION_SECTION],
        ['overview_add_widget', self::TRANSLATION_SECTION],
        ['overview_all_widgets', self::TRANSLATION_SECTION],
        ['overview_cancel', self::TRANSLATION_SECTION],
        ['overview_edit_widget', self::TRANSLATION_SECTION],
        ['overview_save', self::TRANSLATION_SECTION],
        ['overview_widget_label', self::TRANSLATION_SECTION],
        ['overview_erroneous_widget', self::TRANSLATION_SECTION],
        ['overview_refresh', self::TRANSLATION_SECTION],
        ['overview_widget_without_data', self::TRANSLATION_SECTION],
        ['overview_error_occurred', self::TRANSLATION_SECTION],
        ['overview_manage', self::TRANSLATION_SECTION],
        ['overview_lock_dashboard', self::TRANSLATION_SECTION],
        ['overview_unlock_dashboard', self::TRANSLATION_SECTION],
        ['overview_empty_state_heading', self::TRANSLATION_SECTION],
        ['overview_empty_state_subtext', self::TRANSLATION_SECTION],
        ['overview_search_label', self::TRANSLATION_SECTION],
        ['overview_refresh_interval_none', self::TRANSLATION_SECTION],
        ['overview_refresh_interval_minute', self::TRANSLATION_SECTION],
        ['overview_refresh_interval_seconds', self::TRANSLATION_SECTION],
        ['overview_refresh_interval_minutes', self::TRANSLATION_SECTION],
        ['overview_refresh_interval_hour', self::TRANSLATION_SECTION],
        ['overview_delete_widget', self::TRANSLATION_SECTION],
        ['overview_delete_widget_confirmation', self::TRANSLATION_SECTION],
        ['overview_refresh_interval_every', self::TRANSLATION_SECTION]
    ];
    
    
    /**
     * @inheritDoc
     */
    public function handle(Request $request, Response $response): Response
    {
        foreach (self::TRANSLATIONS as $translation) {
            $this->addVuePageTranslation(...$translation);
        }
        
        return $response->write($this->render($this->translate('overview_page_title', self::TRANSLATION_SECTION),
                                              dirname(__DIR__, 3) . '/ui/overview.html'));
    }
    
    
    /**
     * @inheritDoc
     */
    protected function jsEntrypoint(): string
    {
        return self::JAVASCRIPT_ENTRYPOINT;
    }
}